package cn.com.duiba.activity.center.api.remoteservice.duibaactivity;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/23.
 */
public interface RemoteDuibaActivityServiceNew {
    public int updateAutoOffDateNull(Long id);

    /**
     * @Title: findPage
     * @Description: 分页列表
     * @param queryMap
     * @return
     */
    public List<DuibaActivityDto> findPage(Map<String, Object> queryMap);

    /**
     * 
     * findDuibaActivity:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param queryMap
     * @return
     * @since JDK 1.6
     */
    public List<DuibaActivityDto> findDuibaActivity(Map<String, Object> queryMap);

    /**
     * @Title: findPageCount
     * @Description: 分页列表总个数
     * @param queryMap
     * @return
     */
    public Integer findPageCount(Map<String, Object> queryMap);


    /**
     * @Title: findPageCount
     * @Description: 分页列表总个数
     * @param queryMap
     * @return
     */

    public Integer getCountDuibaActivity(Map<String, Object> queryMap);
    /**
     * 获取所有开启和关闭的 活动
     *
     * @param appId
     * @return
     */
    public List<AddActivityDto> findAllDuibaActivity(Long appId);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID in
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<DuibaActivityDto> findAllByIds(List<Long> ids);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaActivityDto find(Long id);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityDO
     * @return
     * @since JDK 1.6
     */
    public DuibaActivityDto insert(DuibaActivityDto duibaActivityDO);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityDO
     * @since JDK 1.6
     */
    public void update(DuibaActivityDto duibaActivityDO);

    /**
     * 
     * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public List<DuibaActivityDto> findAutoOff();

    /**
     * 后台关闭并且下架专题活动
     */
    public DubboResult<DuibaActivityDto> closeAndUnViewDuibaActivity(Long id);

    /**
     * 添加活动到开发者运营活动,这个方法手机端在用
     */
    public DubboResult<Long> addDuibaActivityToDeveloper(Long appId, Long duibaActivityId, String isPreview);

    /**
     * 添加活动到开发者运营活动,这个方法manager端在用
     */
    public DubboResult<Long> addDuibaActivityToDeveloper_manager(Long appId, Long duibaActivityId, String isPreview);

    /**
     * 添加活动到开发者运营活动,这个方法developer端在用
     */
    public DubboResult<Long> addDuibaActivityToDeveloper_developer(Long appId, Long duibaActivityId, String isPreview);

    /**
     * 获取最小积分
     */
    public DubboResult<Long> getDuibaActivityCredits(List<Long> itemIds, Long appId);

    /**
     * 把所有item推送到app入口
     */
    public DubboResult<Void> doMainPushAppItem(Long aid, ItemDto item);

    /**
     * 把所有item更新推送到app入口
     */
    public DubboResult<Void> doUpdateMainPushAppItem(Long appItemId, ItemDto item);

    /**
     * 添加定向分配到定向表
     * @param id
     * @param appIds
     */
    public DubboResult<Void> addDuibaActivityAppSpecify(Long id, String[] appIds);

    /**
     * 后台创建兑吧专题活动-创建权限
     */
    public DubboResult<Void> createDuibaActivity(DuibaActivityDto duibaActivity);

    /**
     * 后台更新兑吧专题活动-更新权限
     */
    public DubboResult<Void> updateDuibaActivity(DuibaActivityDto duibaActivity);

    /**
     * 后台开启专题活动
     */
    public DubboResult<Void> startupDuibaActivity(Long id);

    /**
     * 后台关闭专题活动
     */
    public DubboResult<DuibaActivityDto> closeDuibaActivityNoTransaction(Long id);

    /**
     * 后台删除专题活动
     */
    public DubboResult<DuibaActivityDto> deleteDuibaActivity(Long id);

    //from DuibaActivityService in developer
    /**
     * 开发者端查询所有后台发布中的活动
     */
    public DubboResult<List<AddActivityDto>> findAllDuibaActivity(AppSimpleDto app);

    /**
     * 获取去除对开发者不可见活动后的列表
     *
     * @param app
     * @return
     */
    DubboResult<List<AddActivityDto>> findAllDuibaActivityWithOutHiddenForDev(AppSimpleDto app);
}
