package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersSimpleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by ZQian on 2016/8/1.
 */
public interface RemoteGameOrdersSimpleService {
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param gameOrderId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<GameOrdersDto> find(Long gameOrderId);

    /**
     * 
     * findByAppAndDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param bizId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<GameOrdersDto> findByAppAndDeveloperBizId(Long appId, String bizId);

    /**
     * 
     * findByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<GameOrdersDto>> findByIds(List<Long> ids);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param gameOrdersDO
     * @return
     * @since JDK 1.6
     */
    public DubboResult<GameOrdersDto> insert(GameOrdersDto gameOrdersDO);

    /**
     * 
     * findConsumerFreeNumber:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> findConsumerFreeNumber(Long consumerId, Long operatingActivityId);

    /**
     * 
     * findConsumerFreeNumberByDate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

    /**
     * 
     * findConsumerLimitNumber:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> findConsumerLimitNumber(Long consumerId, Long operatingActivityId);

    /**
     * 
     * findConsumerLimitNumberByDate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

    /**
     * 
     * countConsumerByPrizeId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @param prizeId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

    /**
     * 
     * countConsumerByGameConfigDuibaId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameConfigDuibaId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);

    /**
     * 
     * findOverdueOrder:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<Long>> findOverdueOrder();

    /**
     * 
     * countRow:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Long> countRow(Map<String, Object> params);

    /**
     * 
     * findByLimit:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param params
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<GameOrdersSimpleDto>> findByLimit(Map<String, Object> params);

    /**
     * 
     * countFailByOperatingActivityIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<DeveloperActivityStatisticsDto>> countFailByOperatingActivityIds(List<Long> ids);
}
