package cn.com.duiba.activity.center.api.remoteservice.happycode;


import cn.com.duiba.activity.center.api.dto.happy_code.HappyCodeOrderDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by hww on 2017/12/5
 */
@AdvancedFeignClient
public interface RemoteHappyCodeOrderService {

    /**
     * 新增开心码子订单
     * @param happyCodeOrderDto
     * @return
     */
    Long insert(HappyCodeOrderDto happyCodeOrderDto);

    /**
     * 生成开心码后，将开心码、期次信息更新入子订单中
     * @param happyCodeOrderDto
     * @return
     */
    int updateHappyCodeAndPhase(HappyCodeOrderDto happyCodeOrderDto);

    /**
     * 根据id查询开心码自订单
     * @param id
     * @return
     */
    HappyCodeOrderDto findOrderById(Long id);

    /**
     * 更新中奖信息至订单
     * @param happyCodeOrderDto
     * @return
     */
    int updatePrizeInfo(HappyCodeOrderDto happyCodeOrderDto);

    /**
     * 根据期次和用户id查询用户的订单
     * @param phaseId
     * @param consumerId
     * @return
     */
    List<HappyCodeOrderDto> findOrderByPhaseIdAndConsumerId(Long phaseId, Long consumerId);

    /**
     * 根据期次和用户id查询用户的订单
     * @param phaseId
     * @param count
     * @return
     */
    List<HappyCodeOrderDto> findNewestOrderByPhaseIdAndCount(Long phaseId, Integer count);

    /**
     * 根据id批量查询订单
     * @param orderIds
     * @return
     */
    List<HappyCodeOrderDto> findOrderByIds(Long consumerId, List<Long> orderIds);



}
