package cn.com.duiba.activity.center.api.remoteservice.hdtool;


import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 
 * ClassName: RemoteDuibaHdtoolOptionsService <br/>
 * date: 2016年12月1日 下午3:23:23 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaHdtoolOptionsService {
    /**
     * 
     * findByHdtoolId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param hdtoolId
     * @return
     * @since JDK 1.6
     */
	public List<DuibaHdtoolOptionsDto> findByHdtoolId(Long hdtoolId);

	/**
	 * 
	 * addRemainingById:(这里用一句话描述这个方法的作用). <br/>
	 * 增加奖品数量
	 * @param id
	 * @param addRemaining
	 * @return
	 * @since JDK 1.6
	 */
	public int addRemainingById(Long id, Integer addRemaining);

	/**
	 * 
	 * subRemainingById:(这里用一句话描述这个方法的作用). <br/>
	 * 减少奖品数量
	 * @param id
	 * @param subRemaining
	 * @return
	 * @since JDK 1.6
	 */
	public int subRemainingById(Long id, Integer subRemaining);

	/**
	 * 
	 * updateRemainingById:(这里用一句话描述这个方法的作用). <br/>
	 * 更新库存
	 * @param id
	 * @param remaining
	 * @return
	 * @since JDK 1.6
	 */
	public int updateRemainingById(Long id, Integer remaining);

	/**
	 * 查询奖项剩余库存，加锁
	 * @param id
	 * @return
	 */
	public Integer findRemaingForupdate(Long id);
}
