package cn.com.duiba.activity.center.api.enums;

/**
 * ClassName:BookTypeEnum.java <br/>
 * 书类型枚举类
 *
 * @author xukaiqiang
 * @version 1.0
 * @date 创建时间：2018年06月13日 上午10:02:54
 * @since JDK 1.8
 */
public enum BookTypeEnum {

    ORIGINAL_NOVEL(1, "原创小说"),
    ADAPT_NOVEL(2, "改编小说"),
    LIGHT_NOVEL(3, "轻小说"),
    INSET_IMG(4, "插画"),
    PICTURE_BOOK(5, "绘本");

    private Integer value;

    private String desc;

    BookTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean belong(Integer value) {
        for (BookTypeEnum bookType : BookTypeEnum.values()) {
            if (bookType.value.equals(value)) {
                return true;
            }
        }
        return false;
    }

}
