package cn.com.duiba.activity.center.api.remoteservice.book;

import cn.com.duiba.activity.center.api.dto.BizResultDto;
import cn.com.duiba.activity.center.api.dto.book.BookCheatRecordDto;
import cn.com.duiba.activity.center.api.dto.book.BookInfoDto;
import cn.com.duiba.activity.center.api.dto.book.PrizeBookDto;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * ClassName:RemoteBookService.java <br/>
 * 书旗金龙奖-书
 *
 * @author xukaiqiang
 * @version 1.0
 * @apiNote 创建时间：2018年06月13日 上午10:02:54
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteBookService {

    /**
     * 批量添加书，并初始化排行榜（征稿阶段）
     *
     * @param bookInfoDtos 书对象集合
     */
    List<BookInfoDto> saveBooks(List<BookInfoDto> bookInfoDtos);

    /**
     * 查询书列表（征稿阶段）
     *
     * @param pageSize 分页参数
     * @param pageNo   分页参数
     * @param bookType     书类型
     */
    Page<BookInfoDto> listBookInCollectStage(Integer pageSize, Integer pageNo, Integer bookType);

    /**
     * 查询书列表（投票阶段）
     *
     * @param bookType     书类型
     * @param bookIds  书编号
     */
    Page<BookInfoDto> listBookInBallotStage(Integer bookType, List<Long> bookIds);

    /**
     * 查询获奖记录（开奖阶段）
     */
    PrizeBookDto listBookInPrizeStage();

    /**
     * 作弊（投票阶段）
     *
     * @param opType   加或减
     * @param bookId 书编号
     * @param opNumber 数量
     */
    List<BookCheatRecordDto> saveCheatAndListCheats(Long bookId, Integer opType, Long opNumber);

    /**
     * 批量更新票数（开奖阶段）
     */
    BizResultDto updateBatchBallot(List<BookInfoDto> list);

    /**
     * 修改书（征稿阶段）
     *
     * @param bookInfoDto 书对象
     */
    BizResultDto updateBook(BookInfoDto bookInfoDto);

    /**
     * 查询书
     *
     * @param bookId 书编号
     */
    BookInfoDto getBook(Long bookId);

    /**
     * 根据数据类型查询数据id
     * @param bookType
     * @return
     */
    List<Long> findBookIdsByBookType(Integer bookType);

}
