package cn.com.duiba.activity.center.api.remoteservice.seedredpacket;

import cn.com.duiba.activity.center.api.dto.seedredpacket.SeedRedPacketDto;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.biz.tool.duiba.dto.page.PageQuery;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description
 */
@AdvancedFeignClient
public interface RemoteBackendSeedRedPacketService {

    /**
     * 新增
     */
    long insert(SeedRedPacketDto config) throws BizException;

    /**
     * 更新
     */
    boolean updateGeneral(SeedRedPacketDto config);

    /**
     * 删除
     */
    int deleted(Long id);

    /**
     * 状态变更
     */
    int updateStatus(Long id, Integer status);

    /**
     * 分页查询
     */
    Page<SeedRedPacketDto> findByPage(PageQuery pageQuery, String title);

    /**
     * 查看详情
     */
    SeedRedPacketDto findById(Long id);

}
