package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetListRecordDto;
import cn.com.duiba.activity.center.api.dto.bet.BetRecordDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/08
 */
@AdvancedFeignClient
public interface RemoteBetRecordService {
    /**
     * 更新押注记录
     * @param betRecordDto 需要更新的参数
     * @return 影响行数
     * @throws BizException bizException
     */
    Integer update(BetRecordDto betRecordDto) throws BizException;

    /**
     * 通过id查询押注记录
     * @param id id
     * @return BetRecordDto
     */
    BetRecordDto findById(Long id);

    /**
     * 往日胜利战绩
     * @param consumerId consumerId
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return List<BetListRecordDto>
     */
    Page<BetListRecordDto> list(Long consumerId, Integer pageNo, Integer pageSize);
}
