package cn.com.duiba.activity.center.api.remoteservice.chaos;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/22.
 */
@AdvancedFeignClient
public interface RemoteActPreStockService {
    /**
     * 
     * addAppActPreStock:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param configId
     * @param prizeId
     * @param quantity
     * @param name
     * @param relationType
     * @param appId
     * @since JDK 1.6
     */
    void addAppActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType, Long appId);

    /**
     * 
     * addShareActPreStock:(这里用一句话描述这个方法的作用). <br/>
     * 新增共享预分配库存
     * @param configId
     * @param prizeId
     * @param quantity
     * @param name
     * @param relationType
     * @since JDK 1.6
     */
    void addShareActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType);

    /**
     * 
     * refreshActPreStock:(这里用一句话描述这个方法的作用). <br/>
     * 刷新共享预分配库存
     * @param prizeId
     * @param relationType
     * @param appId
     * @param quantity
     * @param name
     * @return
     * @since JDK 1.6
     */
    int refreshActPreStock(Long prizeId, String relationType, Long appId, Long quantity, String name);

    /**
     * 
     * deleteActStock:(这里用一句话描述这个方法的作用). <br/>
     * 删除活动，则删除
     * @param configId
     * @param relationType
     * @return
     * @since JDK 1.6
     */
    int deleteActStock(Long configId, String relationType);

    /**
     * 删除活动的奖品
     *
     * @param configId
     * @param prizeId
     * @param relationType
     * @return
     */
    int deleteActPrizeStock(Long configId, Long prizeId, String relationType);

    /**
     * 
     * deleteActStockAppId:(这里用一句话描述这个方法的作用). <br/>
     * 删除appId
     * @param prizeId
     * @param relationType
     * @param appId
     * @return
     * @since JDK 1.6
     */
    int deleteActStockAppId(Long prizeId, String relationType, Long appId);

    /**
     * 查询预分配库存
     *
     * @param prizeId
     * @param relationType
     * @param appId
     * @return
     */
    ActPreStockDto findPreStock(Long prizeId, String relationType, Long appId);

    /**
     * 查询预分配库存,根据配置id
     *
     * @param configId
     * @param relationType
     * @return
     */
    @RequestMapping("/ffindPreStock1")
    List<ActPreStockDto> findPreStock(Long configId, String relationType);

    /**
     * 根据奖品类型及id查询活动预分配定向库存
     *
     * @param relationPrizeId
     * @param relationType
     * @param appId
     * @return
     */
    ActPreStockDto findPreStockByApp(Long relationPrizeId, String relationType, Long appId);
    
    /**
     * 根据奖品类型及id查询活动预分配定向库存
     *
     * @param relationPrizeIds
     * @param relationType
     * @param appId
     * @return List<ActPreStockDto>
     */
    List<ActPreStockDto> findPreStockListByApp(List<Long> relationPrizeIds, String relationType, Long appId);

    /**
     * 根据奖品类型及id查询活动预分配共享库存
     *
     * @param relationPrizeId
     * @param relationType
     * @return
     */
    ActPreStockDto findPreStockByShare(Long relationPrizeId, String relationType);

    /**
     * 加锁查询
     *
     * @param id
     * @return
     */
    ActPreStockDto findByLock(Long id);

    /**
     * 减库存
     *
     * @param id
     * @return
     */
    int decrementRemaining(Long id);

    /**
     * 返库存
     *
     * @param id
     * @return
     */
    int incrementRemaining(Long id);

    /**
     * 加库存
     *
     * @param id
     * @param addRemaining
     * @return
     */
    int addRemainingById(Long id, Long addRemaining);

    /**
     * 减库存
     *
     * @param id
     * @param subRemaining
     * @return
     */
    int subRemainingById(Long id, Long subRemaining);

    /**
     * 插入记录
     *
     * @param actPreStockDO
     */
    ActPreStockDto insert(ActPreStockDto actPreStockDO);

    /**
     * 更新记录
     *
     * @param actPreStockDO
     */
    int update(ActPreStockDto actPreStockDO);

    /**
     * 
     * findActStockByConfigId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param configId
     * @param relationType
     * @return
     * @since JDK 1.6
     */
    List<ActPreStockDto> findActStockByConfigId(Long configId, String relationType);

    /**
     *增加批量查询库存的方法
     * @param stockIds
     * @return
     */
    DubboResult<Map<Long,Long>> batchFindStock(List<Long> stockIds);

    /**
     * 增加根据stockId查询库存的方法
     * @param stockId
     * @return
     */
    DubboResult<Long> findStock(Long stockId);


}
