package cn.com.duiba.activity.center.api.remoteservice.seckill;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.seckill.DuibaSeckillDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: RemoteDuibaSeckillServiceNew <br/>
 * date: 2016年12月1日 下午5:28:03 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaSeckillServiceNew {

    /**
     * 
     * findAllOpenedByIds:(这里用一句话描述这个方法的作用). <br/>
     * 批量查询秒杀活动
     * @param ids
     * @return
     * @since JDK 1.6
     */
	List<DuibaSeckillDto> findAllOpenedByIds(List<Long> ids);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSeckillDO
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSeckillDto insert(DuibaSeckillDto duibaSeckillDO);
	/**
	 * 
	 * findByPage:(这里用一句话描述这个方法的作用). <br/>
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillDto> findByPage(Map<String, Object> queryMap);
	/**
	 * 
	 * findPageCount:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public Long findPageCount();
	/**
	 * 
	 * findPageCount:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	@RequestMapping("/findPageCount1")
	public Long findPageCount(Map<String, Object> queryMap);
	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSeckillDto find(Long id);
	/**
	 * 
	 * findTagById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public String findTagById(Long id);
	/**
	 * 
	 * findEffective:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillDto> findEffective();
	/**
	 * 
	 * updateStatus:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param status
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStatus(Long id, int status);
	/**
	 * 
	 * updateTagById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param tag
	 * @return
	 * @since JDK 1.6
	 */
	public int updateTagById(Long id, String tag);
	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int delete(Long id);
	/**
	 * 
	 * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int updateAutoOffDateNull(Long id);
	/**
	 * 
	 * updateInfoForm:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaSeckillDO
	 * @return
	 * @since JDK 1.6
	 */
	public int updateInfoForm(DuibaSeckillDto duibaSeckillDO);

	/**
	 * 
	 * updateSwitches:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param switches
	 * @since JDK 1.6
	 */
	public void updateSwitches(Long id, Long switches);
	
	/**
	 * 
	 * findByMap:(这里用一句话描述这个方法的作用). <br/>
	 * 查询秒杀活动列表
	 * @param paramMap
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillDto> findByMap(Map<String, Object> paramMap);

	/**
	 * 
	 * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSeckillDto> findAllByIds(List<Long> ids);

	/**
	 * 
	 * findAllSeckill:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public List<AddActivityDto> findAllSeckill(Long appId);

	/**
	 * 
	 * update:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaSeckillDto
	 * @since JDK 1.6
	 */
	public void update(DuibaSeckillDto duibaSeckillDto);

	//from DuibaSeckillServiceImpl

	//from credits
	public DubboResult<Long> addDuibaSeckillToDeveloper(Long appId, Long duibaSeckillId, String isPreview) ;

	//from developer/manager 名字重复,所以加入_backend后缀
	public DubboResult<Long> addDuibaSeckillToDeveloper_backend(Long appId, Long duibaSeckillId, String isPreview) ;

	public DubboResult<Void> updateBannerAndAppItem(Long seckillId, Integer status);


}
