/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.exception.ActivityTypeException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public enum ActivityTypeEnum {
    ACTIVITY_TOOL(12, "\u6d3b\u52a8\u5de5\u5177"),
    ZHANGTI_ACTIVITY(0, "\u4e13\u9898\u6d3b\u52a8"),
    QUESTION_ANSWER(40, "\u7b54\u9898\u6d3b\u52a8"),
    SECONDS_KILL(30, "\u79d2\u6740\u4e13\u9898"),
    SECONDS_ACTIVITY(31, "\u5151\u5427\u79d2\u6740\u6d3b\u52a8"),
    QUIZZ(41, "\u6d4b\u8bd5\u9898"),
    GAME(28, "\u6e38\u620f"),
    GUESS(42, "\u7ade\u731c\u6d3b\u52a8"),
    CREDIT_GAME(46, "\u79ef\u5206\u6e38\u620f"),
    LITTLE_GAME(47, "\u5c0f\u6e38\u620f"),
    ROB(45, "\u4eca\u65e5\u5fc5\u62a2"),
    PLUGIN(50, "\u63d2\u4ef6\u6d3b\u52a8"),
    SINGLE_LOTTERY(2, "\u5151\u5427\u5355\u54c1\u62bd\u5956"),
    APP_SINGLE_LOTTERY(3, "\u81ea\u6709\u5355\u54c1\u62bd\u5956"),
    MANUAL_LOTTERY(5, "\u624b\u52a8\u5f00\u5956"),
    SIGN(51, "\u7b7e\u5230\u6d3b\u52a8"),
    TURNTABLE(1, "\u5927\u8f6c\u76d8"),
    ELASTIC_GIFTS(49, "\u5f39\u5c42\u6d3b\u52a8");

    private Integer type;
    private String name;
    private static final HashMultimap<ActivityTypeEnum, Integer> TYPE_MAP;
    private static final Map<Integer, ActivityTypeEnum> REVERSE_MAP;

    private ActivityTypeEnum(Integer type, String name) {
        this.name = name;
        this.type = type;
    }

    public List<Integer> getSuportActivityTypeList() {
        return Lists.newArrayList((Iterable)TYPE_MAP.get((Object)this));
    }

    public String getName() {
        return this.name;
    }

    public Integer getType() {
        return this.type;
    }

    public static ActivityTypeEnum getEnumType(Integer type) {
        if (!REVERSE_MAP.containsKey(type)) {
            throw new ActivityTypeException(type);
        }
        return REVERSE_MAP.get(type);
    }

    static {
        TYPE_MAP = HashMultimap.create();
        REVERSE_MAP = Maps.newHashMap();
        TYPE_MAP.putAll((Object)ACTIVITY_TOOL, OperatingActivityDto.hdToolTypeSet);
        TYPE_MAP.putAll((Object)GAME, OperatingActivityDto.GAME_TYPES);
        TYPE_MAP.put((Object)ZHANGTI_ACTIVITY, (Object)0);
        TYPE_MAP.putAll((Object)QUESTION_ANSWER, OperatingActivityDto.questionTypeSet);
        TYPE_MAP.put((Object)SECONDS_KILL, (Object)SECONDS_KILL.getType());
        TYPE_MAP.put((Object)SECONDS_ACTIVITY, (Object)SECONDS_ACTIVITY.getType());
        TYPE_MAP.put((Object)QUIZZ, (Object)QUIZZ.getType());
        TYPE_MAP.put((Object)GUESS, (Object)GUESS.getType());
        TYPE_MAP.put((Object)CREDIT_GAME, (Object)CREDIT_GAME.getType());
        TYPE_MAP.put((Object)LITTLE_GAME, (Object)LITTLE_GAME.getType());
        TYPE_MAP.put((Object)ROB, (Object)ROB.getType());
        TYPE_MAP.put((Object)PLUGIN, (Object)PLUGIN.getType());
        TYPE_MAP.put((Object)SINGLE_LOTTERY, (Object)SINGLE_LOTTERY.getType());
        TYPE_MAP.put((Object)APP_SINGLE_LOTTERY, (Object)APP_SINGLE_LOTTERY.getType());
        TYPE_MAP.put((Object)MANUAL_LOTTERY, (Object)MANUAL_LOTTERY.getType());
        TYPE_MAP.put((Object)SIGN, (Object)SIGN.getType());
        TYPE_MAP.put((Object)TURNTABLE, (Object)TURNTABLE.getType());
        TYPE_MAP.put((Object)ELASTIC_GIFTS, (Object)ELASTIC_GIFTS.getType());
        for (ActivityTypeEnum typeEnum : TYPE_MAP.keySet()) {
            for (Integer type : TYPE_MAP.get((Object)typeEnum)) {
                REVERSE_MAP.put(type, typeEnum);
            }
        }
    }
}

