/**
 * Project Name:activity-center-api File Name:DefinedActivityTypesDto.java Package
 * Name:cn.com.duiba.activity.center.api.dto.gamecenter Date:2016年10月20日下午8:20:46 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.api.dto.gamecenter;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

import java.io.Serializable;

/**
 * ClassName:DefinedActivityTypesDto <br/>
 * Function: 游戏中心支持的活动类型定义. <br/>
 * Date: 2016年10月20日 下午8:20:46 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public final class DefinedActivityTypesDto implements Serializable{

    private static final long serialVersionUID = 1412103289793442763L;

    /** 活动工具. */
    public static final int NEW_HDTOOL      = OperatingActivityDto.TypeHdToolTurntable;

    /** 专题活动. */
    public static final  int DUIBA_ACTIVITY  = OperatingActivityDto.TypeDuibaActivity;

    /** 单品抽奖. */
    public static final int SINGLE_LOTTERY  = OperatingActivityDto.TypeDuibaSingleLottery;

    /** 秒杀专题. */
    public static final int SECONDS_KILL    = OperatingActivityDto.TypeSecondsKill;

    /** 新游戏. */
    public static final int NGAME           = OperatingActivityDto.TypeDuibaNgame;

    /** 答题. */
    public static final int QUESTION_ANSWER = OperatingActivityDto.TypeDuibaQuestionAnswer;

    /** 秒杀活动. */
    public static final int DUIBA_SEC_KILL  = OperatingActivityDto.TypeDuibaSeckill;

    /** 测试题. */
    public static final int QUIZZ           = OperatingActivityDto.TypeDuibaQuizz;

    /** 竞猜. */
    public static final int GUESS           = OperatingActivityDto.TypeDuibaGuess;

    /** 小游戏. */
    public static final  int LITTLE_GAME     = OperatingActivityDto.TypeDuibaLittleGame;

}
