/**
 * Project Name:activity-center-api
 * File Name:SignConfigDto.java
 * Package Name:cn.com.duiba.activity.center.api.dto.sign
 * Date:2016年10月22日下午2:01:42
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.dto.sign;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName:SignConfigDto <br/>
 * Date:     2016年10月22日 下午2:01:42 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class SignConfigDto implements Serializable {

    /**
     * serialVersionUID:(用一句话描述这个变量表示什么).
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -3434235593009164092L;
    
    public static final Integer SWITCHES_ANTICHEAT_LIMIT_RULE = 0; // 开启直充类奖品防刷

    public static final Integer SWITCHES_RECORD_JOIN_NUM = 1; // 参与人数的记录开关

    public static final int    STATUS_CLOSE      = 0;                    // 关闭
    public static final int    STATUS_OPEN            = 1;                    // 开启
    
    public static final int    TYPE_CONTINUE      = 0;                    // 连续签到
    public static final int    TYPE_CIRCLE            = 1;                    // 周期签到
    
    private Long id;
    private Long appId;
    private String title;
    private Long brickId;
    private String ruleDescription;
    private String rateDescription;
    private String triggerType;
    private Integer signType;
    private String signCredits;
    private String imageUrl;
    private Integer status;
    private Integer deleted;
    private Date gmtCreate;
    private Date gmtModified;
    //位运算标识
    private Integer switches;
    
    /**
     * 
     * openSwitch:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param s
     * @since JDK 1.6
     */
    public void openSwitch(int s) {
        int v = 1 << s;
        switches = switches | v;
    }

    /**
     * 
     * closeSwitch:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param s
     * @since JDK 1.6
     */
    public void closeSwitch(int s) {
        int v = 1 << s;
        v = ~v;
        switches = switches & v;
    }
    
    /**
     * 
     * isOpenSwitch:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param s
     * @return
     * @since JDK 1.6
     */
    public boolean isOpenSwitch(int s) {
        int v = 1 << s;
        int ret = switches & v;
        return ret != 0;
    }
    
    public Integer getSwitches() {
        return switches;
    }
    
    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public Long getAppId() {
        return appId;
    }
    
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    
    public String getTitle() {
        return title;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public Long getBrickId() {
        return brickId;
    }
    
    public void setBrickId(Long brickId) {
        this.brickId = brickId;
    }
    
    public String getRuleDescription() {
        return ruleDescription;
    }
    
    public void setRuleDescription(String ruleDescription) {
        this.ruleDescription = ruleDescription;
    }
    
    public String getRateDescription() {
        return rateDescription;
    }
    
    public void setRateDescription(String rateDescription) {
        this.rateDescription = rateDescription;
    }
    
    public String getTriggerType() {
        return triggerType;
    }
    
    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }
    
    public Integer getSignType() {
        return signType;
    }
    
    public void setSignType(Integer signType) {
        this.signType = signType;
    }
    
    public String getSignCredits() {
        return signCredits;
    }
    
    public void setSignCredits(String signCredits) {
        this.signCredits = signCredits;
    }
    
    public String getImageUrl() {
        return imageUrl;
    }
    
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }
    
    public Integer getStatus() {
        return status;
    }
    
    public void setStatus(Integer status) {
        this.status = status;
    }
    
    public Integer getDeleted() {
        return deleted;
    }
    
    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }
    
    public Date getGmtCreate() {
        return gmtCreate;
    }
    
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    
    public Date getGmtModified() {
        return gmtModified;
    }
    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

