package cn.com.duiba.activity.center.api.remoteservice.singlelottery;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/6/20.
 */
@AdvancedFeignClient
public interface RemoteSingleLotteryServiceNew {

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询
     * @param id
     * @return
     * @since JDK 1.6
     */
    public AppSingleLotteryDto find(Long id);

    /**
     *
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DubboResult<AppSingleLotteryDto> findWithExchangeLimit(Long id);


    /**
     * 更新单品抽奖的奖项库存
     */
    public DubboResult<Void> updateMainAppItemRemainingByEdit(Long appSingleLotteryId, Integer preRemaining, Integer requiredRemaining) ;


    /**
     * 创建
     */
    public DubboResult<Void> createSingleLottery(AppSingleLotteryDto asl);

    /**
     * updateSingleLotteryAndUpdateMainAppItemRemainingByEdit这个方法是把remoteSingleLotteryService.updateSingleLottery(asl);和remoteSingleLotteryService.updateMainAppItemRemainingByEdit(asl.getId(), preMainAppItemRemaining, remainingNum);集成到一个方法中,以支持事务
     *AppSingleLotteryCtrl中原来没有此方法,是合成的,来自AppSingleLotteryCtrl.update
     * @param asl
     * @param preMainAppItemRemaining
     * @param remainingNum
     * @throws BusinessException
     */
    public DubboResult<Void> updateSingleLotteryAndUpdateMainAppItemRemainingByEdit(AppSingleLotteryDto asl, Integer preMainAppItemRemaining, Integer remainingNum);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID集合查询开发者单品抽奖
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<AppSingleLotteryDto> findAllByIds(List<Long> ids);

    /**
     * 
     * addMainAppItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 增加主奖品的数量
     * @param id
     * @param addMainAppItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining);

    /**
     * 
     * subMainAppItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 减少主奖品的数量
     * @param id
     * @param subMainAppItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 新增开发者单品抽奖
     * @param appSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public AppSingleLotteryDto insert(AppSingleLotteryDto appSingleLotteryDO);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID修改
     * @param appSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public int update(AppSingleLotteryDto appSingleLotteryDO);

    /**
     * 
     * reduceMainAppItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 减主奖品剩余个数
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int reduceMainAppItemRemaining(Long id);

    /**
     * 
     * addMainAppItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 加主奖品剩余个数
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int addMainAppItemRemaining(Long id);

    /**
     * 
     * updateForDevEdit:(这里用一句话描述这个方法的作用). <br/>
     * 开发者后台更新
     * @param appSingleLottery
     * @return
     * @since JDK 1.6
     */
    public int updateForDevEdit(AppSingleLotteryDto appSingleLottery);

    /**
     * 
     * findRemaingForupdate:(这里用一句话描述这个方法的作用). <br/>
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer findRemaingForupdate(Long id);

    /**
     * 
     * findForupdate:(这里用一句话描述这个方法的作用). <br/>
     * @param id
     * @return
     * @since JDK 1.6
     */
    public AppSingleLotteryDto findForupdate(Long id);
    
    /**
     * 
     * doAutoOffDateScan:(这里用一句话描述这个方法的作用). <br/>
     * 自由商品  自动下架
     * @return
     * @since JDK 1.6
     */
    public int doAutoOffDateScan();
    
    }
