package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.javatuples.Pair;

import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Map;
import java.util.Set;

/**
 * Created by houwen on 16/8/11.
 */
@AdvancedFeignClient
public interface RemoteActivityConsumerLimitService {

	/**
	 * 查询用户今日参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日参与活动次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日参与活动次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerJoinNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户永久参与参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久参与参与活动次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久参与参与活动次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerJoinNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户今日免费参与次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日免费参与次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 用户今日免费参与次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerFreeNumToday(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户永久免费参与次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Integer> findConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久免费参与次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 用户永久免费参与次数减1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 */
	public DubboResult<Boolean> decrConsumerFreeNumForever(Long consumerId, Long operatingActivityId);

	/**
	 * 查询用户活动奖项中奖次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionId
	 * @return
	 */
	public DubboResult<Integer> findConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId);


	/**
	 * 批量查询奖项中奖次数
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionIds
     * @return
     */
	DubboResult<Map<String,Integer>> findConsumerWinOptionNumByOptionIds(Long consumerId, Long operatingActivityId, Set<String> optionIds);

	/**
	 * 用户活动奖项中奖次数加1
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param optionId
	 * @return
	 */
	public DubboResult<Boolean> incrConsumerWinOptionNum(Long consumerId, Long operatingActivityId, String optionId);
	
	
	/**
     * 查询用户永久参与参与活动次数
     * 
     * @param consumerId
     * @param operatingActivityId
     * @return
     */
    public DubboResult<Integer> findConsumerJoinNumForeverNoLimit(Long consumerId, Long operatingActivityId);

    /**
     * 用户永久参与参与活动次数加1
     * 
     * @param consumerId
     * @param operatingActivityId
     * @return
     */
    public DubboResult<Boolean> incrConsumerJoinNumForeverNoLimit(Long consumerId, Long operatingActivityId);


	/**
	 * 查询插件活动首次访问记录（从redis迁移到mysql的长期缓存）
	 * @param consumerId
	 * @param key
	 * @param space
     * @return
     */
	DubboResult<String> findConPluginFirstJoin(Long consumerId, String key, String space);

	/**
	 * 设置插件活动首次访问记录（从redis迁移到mysql的长期缓存）
	 * @param consumerId
	 * @param key
	 * @param value
	 * @param space
     * @return
     */
	DubboResult<Boolean> setConPluginFirstJoin(Long consumerId, String key, String value, String space);
	
	/**
	 * 获取用户限制数-插件是抽奖工具
	 * findConsumerJoinPlugdrawNum:(这里用一句话描述这个方法的作用). <br/>
	 * @author liyang
	 * @param consumerId
	 * @param activityType
	 * @param activityId
	 * @return
	 * @since JDK 1.6
	 */
    public DubboResult<Integer> findConsumerJoinPlugdrawNum(Long consumerId, String activityType, Long activityId);
    
    /**
     * 增加用户限制数-插件是抽奖工具
     * incrConsumerJoinPlugdrawNum:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param consumerId
     * @param activityType
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> incrConsumerJoinPlugdrawNum(Long consumerId, String activityType, Long activityId);
    
    /**
     * 减少用户限制数-插件是抽奖工具
     * descConsumerJoinPlugdrawNum:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param consumerId
     * @param activityType
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> descConsumerJoinPlugdrawNum(Long consumerId, String activityType, Long activityId);
    
    /**
     * 获取每天用户限制数-插件是抽奖工具
     * findConsumerJoinPlugdrawNum:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param consumerId
     * @param activityType
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> findConsumerJoinPlugdrawNumEvery(Long consumerId, String activityType, Long activityId);
    
    /**
     * 增加每天用户限制数-插件是抽奖工具
     * incrConsumerJoinPlugdrawNum:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param consumerId
     * @param activityType
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> incrConsumerJoinPlugdrawNumEvery(Long consumerId, String activityType, Long activityId);
    
    /**
     * 减少每天用户限制数-插件是抽奖工具
     * descConsumerJoinPlugdrawNum:(这里用一句话描述这个方法的作用). <br/>
     * @author liyang
     * @param consumerId
     * @param activityType
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> descConsumerJoinPlugdrawNumEvery(Long consumerId, String activityType, Long activityId);

	/**
	 * 查询用户今日参与活动次数
	 * 
	 * @param consumerId
	 * @param operatingActivityId
	 * @param limitScope
	 * @param freeScope
	 * 
	 * 返回参数  第一个 参与次数(limitCount)  第二个 免费参与次数(freeCount)      数据不存在时  返回0
	 * @return
	 */
	public DubboResult<Pair<Integer, Integer>> findConsumerJoinNumAndFreeNum(Long consumerId, Long operatingActivityId,String limitScope,String freeScope);

	/**
	 * 按类型查询活动奖品发放个数
	 * @param optionId
	 * @param operatingActivityId
	 * @param prizesGrantLimitDays
	 * @return
	 */
	public DubboResult<Long> findGrantNumByType(String optionId, Long operatingActivityId,Integer prizesGrantLimitDays);

	/**
	 * 增加一个奖品发放个数
	 * @param optionId
	 * @param operatingActivityId
	 * @param prizesGrantLimitDays
	 * @return
	 */
	public DubboResult<Boolean> incrGrantNumByType(String optionId, Long operatingActivityId, Integer prizesGrantLimitDays);

	/**
	 * 获取每天用户限制数-插件式抽奖工具（redis不用field）
	 */
	Integer findConsumerJoinPlugdrawNumEveryDay(Long consumerId, String activityType, Long activityId);

	/**
	 * 获取每周用户限制数-插件式抽奖工具
	 */
	Integer findConsumerJoinPlugdrawNumEveryWeek(Long consumerId, String activityType, Long activityId);


	/**
	 * 获取每月用户限制数-插件式抽奖工具
	 */
	Integer findConsumerJoinPlugdrawNumEveryMonth(Long consumerId, String activityType, Long activityId);

	/**
	 * 增加用户限制数（永久+每天+每周+每月）-插件式抽奖工具
	 */
	Boolean incrConsumerJoinPlugdrawNumAll(Long consumerId, String activityType, Long activityId);

}
