package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetConfigDto;
import cn.com.duiba.activity.center.api.dto.bet.BetDto;
import cn.com.duiba.activity.center.api.params.BetConfigParam;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/05/07
 */
@AdvancedFeignClient
public interface RemoteBetConfigService {
    /**
     * 通过id获取活动配置
     * @param id betId
     * @return 活动配置
     * @throws BizException bizException
     */
    BetConfigDto findById(Long id) throws BizException;

    /**
     * 押注
     * @param betConfigParam betConfigParam
     * @return betRecordId
     * @throws BizException bizException
     */
    Long doBet(BetConfigParam betConfigParam) throws BizException;

    /**
     * 首页活动列表
     * @param appId appId
     * @param consumerId consumerId
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return Page<BetDto>
     */
    Page<BetDto> listByAppId(Long appId, Long consumerId, Integer pageNo, Integer pageSize);
}
