package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/09
 */
@AdvancedFeignClient
public interface RemoteBackendBetRecordService {
    /**
     * 获取该活动下选择该选项的用户押注记录
     * @param betId betId
     * @param optionId optionId
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return List<BetRecordDto>
     */
    List<BetRecordDto> list(Long betId, Long optionId, Integer pageNo, Integer pageSize);

    /**
     * 批量更新用户押注记录
     * @param betRecordDtoList betRecordDtoList
     * @return 影响行数
     */
    Integer batchUpdate(List<BetRecordDto> betRecordDtoList);

    /**
     * 获取押注该选项的次数
     * @param betId betId
     * @param optionId optionId
     * @return 个数
     */
    Integer countByOptionIdAndBetId(Long optionId, Long betId);
}
