package cn.com.duiba.activity.center.api.remoteservice.cus;

import cn.com.duiba.activity.center.api.dto.cus.CusUserInviteCountDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/05/24
 */
@AdvancedFeignClient
public interface RemoteCusUserInviteCountService {
    /**
     * 通过用户id获取用户邀请的次数和宝箱状态
     * @param consumerId 用户id
     * @return CusUserInviteCountDto
     */
    CusUserInviteCountDto findByConsumerId(Long consumerId);

    /**
     * 通过用户id更新数据
     * @param cusUserInviteCountDto 需要更新的参数 consumerId必须传
     * @return 是否成功
     */
    Integer updateByConsumerId(CusUserInviteCountDto cusUserInviteCountDto);
}
