package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/7/5.
 */
@AdvancedFeignClient
public interface RemoteHdtoolSkinDataService {

    /**
     * 
     * createHdtoolSkinData:(这里用一句话描述这个方法的作用). <br/>
     * 开发者/兑吧编辑活动模版定制后，创建一条模版数据
     * @param hdtoolSkinEntity
     * @return
     * @since JDK 1.6
     */
    public HdtoolSkinDto createHdtoolSkinData(HdtoolSkinDto hdtoolSkinEntity);

    /**
     * 
     * updateHdtoolSkinData:(这里用一句话描述这个方法的作用). <br/>
     * 编辑模版数据
     * @param hdtoolId
     * @param type
     * @param dataJson
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateHdtoolSkinData(Long hdtoolId, String type, String dataJson);
    
    /**
     * 
     * updateHdtoolSkinDataAppId:(这里用一句话描述这个方法的作用). <br/>
     * 编辑模版数据
     * @param hdtoolId
     * @param type
     * @param dataJson
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateHdtoolSkinDataAppId(Long hdtoolId, String type, String dataJson,Long appId);

    /**
     * 
     * queryBaseHdtoolSkin:(这里用一句话描述这个方法的作用). <br/>
     * 查询活动模版基础配置
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<HdtoolSkinDto> queryBaseHdtoolSkin(Long hdtoolId,String type);
    
    /**
     * 
     * queryBaseHdtoolSkinAppId:(这里用一句话描述这个方法的作用). <br/>
     * 查询活动模版基础配置
     * @param hdtoolId
     * @param type
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<HdtoolSkinDto> queryBaseHdtoolSkinAppId(Long hdtoolId,String type,Long appId);

    /**
     * 查询活动Json数据
     * @author zp
     * @param hdtoolId
     * @param type
     * @return
     * @since JDK 1.6
     */
    public DubboResult<String> querySkin(Long hdtoolId,String type);

    /**
     * 
     * querySkinAppId:(这里用一句话描述这个方法的作用). <br/>
     * 查询活动Json数据
     * @param hdtoolId
     * @param type
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<String> querySkinAppId(Long hdtoolId,String type, Long appId);
}
