package cn.com.duiba.activity.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 插件活动用户领奖验证的验证策略
 * Created by sty on 12/18/17.
 */
public enum PluginJoinVerificyModeEnum {

    NGAMEMUTIRANK(1,"多游戏排行榜验证"),
    OPTIONNUMRANK(2,"奖项数量排行榜验证"),
    UNLOCKINGRECORD(3, "解锁记录验证"),
    NGAMEMUTIRANKSCORE(4,"排行榜最低分数验证"),
    DOCALLSCORE(5,"爱奇艺定制活动打call分数校验"),
    GAME_YESTERDAY_RANK(6, "游戏昨日排行榜验证"),
    FRIEND_POINTS(7, "转转好友力值解锁"),
    GAME_LAST_WEEK_RANK(8, "游戏上周排行榜验证"),
    NEW_USER_COLLECT(21, "新人福利集卡验证"),
    WELFARE_TASK(10, "微博发财日红包校验"),
    CMBC(11, "招商银行活动宝箱校验"),
    LOTTERY_BET_VICTORY_TIMES(12, "博彩活动胜场次数")
    ;

    private Integer code;
    private String desc;

    private static Map<Integer,PluginJoinVerificyModeEnum> typeMap = new HashMap<>();
    static{
        for(PluginJoinVerificyModeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    PluginJoinVerificyModeEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @returActivityPluginDton
     */
    public static PluginJoinVerificyModeEnum getVerificyModeByCode(Integer code){
        return typeMap.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}

