package cn.com.duiba.activity.center.api.remoteservice.quizz;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * Created by xuezhaoming on 16/6/15.
 */
@AdvancedFeignClient
public interface RemoteQuizzStockService {

    /**
     * 
     * subStock:(这里用一句话描述这个方法的作用). <br/>
     * @param id
     * @param subNumber
     * @return
     * @since JDK 1.6
     */
	public int subStock(Long id, Integer subNumber);

	/**
	 * 
	 * addStock:(这里用一句话描述这个方法的作用). <br/>
	 * @param id
	 * @param addNumber
	 * @return
	 * @since JDK 1.6
	 */
	public int addStock(Long id, Integer addNumber);

	/**
	 * 
	 * findRemaining:(这里用一句话描述这个方法的作用). <br/>
	 * @param optionId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto findRemaining(Long optionId);

    //manager

    //from manager
	/**
	 * 
	 * findByQuizzOptionId:(这里用一句话描述这个方法的作用). <br/>
	 * @param questionOptionId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId);

	/**
	 * 
	 * findByQuizzOptionIds:(这里用一句话描述这个方法的作用). <br/>
	 * @param list
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list);

	/**
	 * 
	 * updateStockAdd:(这里用一句话描述这个方法的作用). <br/>
	 * @param id
	 * @param stockAdd
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStockAdd(Long id, Integer stockAdd);

	/**
	 * 
	 * updateStockSub:(这里用一句话描述这个方法的作用). <br/>
	 * @param id
	 * @param stockSub
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStockSub(Long id, Integer stockSub);

	/**
	 * 
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 * @param quizzStockDO
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto add(DuibaQuizzStockDto quizzStockDO);

	/**
	 * 
	 * addBatch:(这里用一句话描述这个方法的作用). <br/>
	 * @param list
	 * @since JDK 1.6
	 */
	public void addBatch(List<DuibaQuizzStockDto> list);

	/**
	 * 
	 * updateStockByOptions:(这里用一句话描述这个方法的作用). <br/>
	 * @param option
	 * @since JDK 1.6
	 */
	public void updateStockByOptions(DuibaQuizzOptionsDto option);
	/**
	 * 
	 * updateStockByOptions:(这里用一句话描述这个方法的作用). <br/>
	 * @param option
	 * @param old
	 * @throws BusinessException
	 * @since JDK 1.6
	 */
	@RequestMapping("/updateStockByOptions1")
	public void updateStockByOptions(DuibaQuizzOptionsDto option, DuibaQuizzOptionsDto old) throws BusinessException;
}
