package cn.com.duiba.activity.center.api.remoteservice.manhua;

import cn.com.duiba.activity.center.api.dto.BizResultDto;
import cn.com.duiba.activity.center.api.dto.manhua.CartoonBookVoteDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 漫漫漫画定制需求 书籍投票服务api
 * Created by sunchangji on 2018/7/11.
 */
@AdvancedFeignClient
public interface RemoteCartoonBookVoteService {
    /**
     * 根据appId查询下所有书籍信息
     * @param appId
     * @return
     */
    List<CartoonBookVoteDto> findAllByAppId(Long appId);

    /**
     * 根据id集合查询所有书籍信息
     * @param ids
     * @return
     */
    List<CartoonBookVoteDto> findByIds(List<Long> ids);

    /**
     * 批量插入书籍
     * @param dtos
     * @return
     */
    BizResultDto batchInsertBook(List<CartoonBookVoteDto> dtos);

    /**
     * 更新书籍信息
     * @param dto
     * @return
     */
    BizResultDto update(CartoonBookVoteDto dto);
}
