package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.enums.NGameRankTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/13.
 */
@AdvancedFeignClient
public interface RemoteDuibaNgameService {
    /**
     * 
     * findByPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param offset
     * @param max
     * @param title
     * @param id
     * @return
     * @since JDK 1.6
     */
    List<DuibaNgameDto> findByPage(Integer offset, Integer max, String title, Integer id);

    /**
     * 
     * findByPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param title
     * @param id
     * @return
     * @since JDK 1.6
     */
    Long findByPageCount(String title, Integer id);

    /**
     * 
     * findOpenPrizeForUpdate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DuibaNgameDto findOpenPrizeForUpdate(Long id);

    /**
     * 
     * count:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    int count();

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DuibaNgameDto find(Long id);
	
    /**
     * 
     * findTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
	String findTagById(Long id);

	/**
	 * 
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameDO
	 * @return
	 * @since JDK 1.6
	 */
    DuibaNgameDto add(DuibaNgameDto duibaNgameDO);

    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    void delete(Long id);
	
    /**
     * 
     * updateTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param tag
     * @return
     * @since JDK 1.6
     */
	int updateTagById(Long id, String tag);

	/**
	 * 
	 * update:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaNgameDO
	 * @since JDK 1.6
	 */
    void update(DuibaNgameDto duibaNgameDO);

    /**
     * 
     * updateSwitch:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaNgameDO
     * @since JDK 1.6
     */
    void updateSwitch(DuibaNgameDto duibaNgameDO);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<DuibaNgameDto> findAllByIds(List<Long> ids);
    /**
     * 
     * findAllNgame:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<AddActivityDto> findAllNgame(Long appId);

    /**
     * 
     * findListByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<DuibaNgameDto> findListByIds(List<Long> ids);
    /**
     * 
     * updateOpenPrize:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int updateOpenPrize(Long id);
    /**
     * 
     * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public List<DuibaNgameDto> findAutoOff();
    /**
     * 
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    public int updateStatus(Long id, Integer status);
    /**
     * 
     * findExtraInfoById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public ActivityExtraInfoDto findExtraInfoById(Long id);
    /**
     * 
     * updateActivityCategoryId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param activityCategoryId
     * @return
     * @since JDK 1.6
     */
	public int updateActivityCategoryId(long id,Long activityCategoryId);

    public DubboResult<Long> addDuibaNgameToDeveloper(Long appId, Long duibaNgameId) ;

    /**
     * ngame手动开奖
     * @param ngameId
     * @return
     */
    DubboResult<Void> openNgame(Long ngameId);

    /**
     * 更新游戏拓展字段
     * @param id
     * @param extendInfo
     * @return
     */
    DubboResult<Integer> updateNgameExtendJson(Long id, Map<String,String> extendInfo);

    /**
     * 根据标题模糊查询已经开启的游戏
     * @param title
     * @return
     */
    List<DuibaNgameDto> findByStatusOpen(String title);

    /**
     * 查询指定排行榜的用户排名
     * 若排名不存在返回 -1
     * @param gameId
     * @param consumer
     * @param type
     * @return
     */
    Long findRank(Long gameId, Long consumer, NGameRankTypeEnum type, Long appId);
}
