package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetConfigDto;
import cn.com.duiba.activity.center.api.dto.bet.BetDto;
import cn.com.duiba.activity.center.api.params.BetConfigParam;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/07
 */
@AdvancedFeignClient
public interface RemoteBetConfigService {
    /**
     * 通过id获取活动配置
     * @param id betId
     * @return 活动配置
     * @throws BizException bizException
     */
    BetConfigDto findById(Long id) throws BizException;

    /**
     * 押注
     * @param betConfigParam betConfigParam
     * @return betRecordId
     * @throws BizException bizException
     */
    Long doBet(BetConfigParam betConfigParam) throws BizException;

    /**
     * 首页活动列表
     * @param appId appId
     * @param consumerId consumerId
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return Page<BetV2Dto>
     */
    Page<BetDto> listByAppId(Long appId, Long consumerId, Integer pageNo, Integer pageSize);

    /**
     * 楼层获取最近一个开奖的押注活动
     * @param groupId 活动组id
     * @param consumerId 用户id
     * @return BetV2Dto
     */
    BetDto listByGroupId(Long groupId, Long consumerId);

    /**
     * 根据状态、瓜分类型和结束时间范围查询活动列表
     * @param configStatus
     * @param bonusType
     * @param startTime
     * @param endTime
     * @return List<BetConfigDto>
     */
    List<BetConfigDto> getListByStatusAndEndTime(Integer configStatus, Integer bonusType, Date startTime, Date endTime);
}
