package cn.com.duiba.activity.center.api.remoteservice.face;

import cn.com.duiba.activity.center.api.dto.face.DuibaFaceImgDto;
import cn.com.duiba.activity.center.api.dto.face.DuibaFaceImgInsertDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by sunchangji on 2018/8/30.
 */
@AdvancedFeignClient
public interface RemoteDuibaFaceImgService {

    /**
     * 新增模板图片到指定的模板集合
     *
     * @param insertDto
     * @return
     */
    boolean insertFaceImg(DuibaFaceImgInsertDto insertDto);

    /**
     * 在一个已有的 FaceSet 中找出与目标人脸最相似的一张
     *
     * @param imageBase64 base64图片
     * @param faceSetId   图片集合id
     * @return 在给定的人脸集合中搜索到匹配的图片faceToken
     */
    DuibaFaceImgDto faceSearchApi(String imageBase64, Long faceSetId);
}
