package cn.com.duiba.activity.center.api.remoteservice.game;


import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDuibaQuestionAnswerOptionsService {

	/**
	 * 此方法在credits中为此名字,在developer中名为findByDuibaQuestionAnswerId,在manager中名为findByQuestionAnswerId,合并成一个
	 * @param duibaQuestionId
	 * @return
     */
	List<DuibaQuestionAnswerOptionsDto> findOptionsByQuestionId(Long duibaQuestionId);

	Map<Long, List<DuibaQuestionAnswerOptionsDto>> findOptionsByQuestionIds(List<Long> duibaQuestionIds);

	DuibaQuestionAnswerOptionsDto find(Long id);


	public DuibaQuestionAnswerOptionsDto findById(Long id);
	public int delete(List<Long> ids);
	public DuibaQuestionAnswerOptionsDto insert(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO);
	public int update(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO);

	//from DuibaQuestionAnswerOptionsServiceImpl in manager
	public List<DuibaQuestionAnswerOptionsDto> findByQuestionAnswerId(Long questionAnswerId);
	
}
