package cn.com.duiba.activity.center.api.remoteservice.happycode;


import cn.com.duiba.activity.center.api.dto.happy_code.HappyCodeOrderDto;
import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.biz.tool.duiba.dto.page.PageQuery;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * Created by hww on 2017/12/5
 */
@AdvancedFeignClient
public interface RemoteHappyCodeOrderService {

    /**
     * 新增开心码子订单
     * @param happyCodeOrderDto
     * @return
     */
    Long insert(HappyCodeOrderDto happyCodeOrderDto);

    /**
     * 生成开心码后，将开心码、期次信息更新入子订单中
     * @param happyCodeOrderDto
     * @return
     */
    int updateHappyCodeAndPhase(HappyCodeOrderDto happyCodeOrderDto);

    /**
     * 根据id查询开心码自订单
     * @param id
     * @return
     */
    HappyCodeOrderDto findOrderById(Long id);

    /**
     * 更新中奖信息至订单
     * @param happyCodeOrderDto
     * @return
     */
    int updatePrizeInfo(HappyCodeOrderDto happyCodeOrderDto);

    /**
     * 根据期次和用户id查询用户的订单
     * @param phaseId
     * @param consumerId
     * @return
     */
    List<HappyCodeOrderDto> findOrderByPhaseIdAndConsumerId(Long phaseId, Long consumerId);

    /**
     * 根据期次和用户id查询用户的订单
     * @param phaseId
     * @param count
     * @return
     */
    List<HappyCodeOrderDto> findNewestOrderByPhaseIdAndCount(Long phaseId, Integer count);

    /**
     * 根据id批量查询订单
     * @param orderIds
     * @return
     */
    List<HappyCodeOrderDto> findOrderByIds(Long consumerId, List<Long> orderIds);

    /**
     * 将订单更新为已领奖状态
     * @param consumerId
     * @param orderId
     * @return
     */
    Integer doTakePrize(Long consumerId, Long orderId);

    /**
     * 失效中奖人已经获取的订单
     */
    int delWinnerOrder(Long phaseId, Long consumerId, Date startDate, Date endDate);

    /**
     * 根据用户id 期次ids 分页查询订单 按照时间倒序排列
     * @return
     */
    Page<HappyCodeOrderDto> findOrderPageByPhaseIdsAndConsumerId(List<Long> phaseIds, Long consumerId, PageQuery pageQuery);

    /**
     * 根据用户id 期次ids 查询订单
     * @return
     */
    List<HappyCodeOrderDto> findOrders(List<Long> phaseIds, Long consumerId);


}
