package cn.com.duiba.activity.center.api.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author: zhengjianhao
 * @date: 18/4/4 16:57
 * @description: 限制周期
 */
public enum LimitScopeEnum {
    EVERY_DAY(0, "everyday", "每日"),
    FOREVER(1, "forever", "永久"),
    EVERY_WEEK(2, "everyWeek", "每周"),
    EVERY_MONTH(3, "everyMonth", "每月");

    Integer id;
    String code;
    String desc;

    LimitScopeEnum(Integer id, String code, String desc) {
        this.id = id;
        this.code = code;
        this.desc = desc;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Integer getIdByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(LimitScopeEnum limitScopeEnum: LimitScopeEnum.values()){
            if(limitScopeEnum.code.equals(code)){
                return limitScopeEnum.id;
            }
        }
        return null;
    }

    public static String getCodeById(Integer id){
        if(null == id){
            return null;
        }
        for(LimitScopeEnum limitScopeEnum: LimitScopeEnum.values()){
            if(limitScopeEnum.id.equals(id)){
                return limitScopeEnum.code;
            }
        }
        return null;
    }
}
