package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.activity.center.api.dto.ActivityCommonDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.enums.DuibaActivityTypeEnum;
import cn.com.duiba.activity.center.api.params.ActivityIdAndTypeParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 活动常用 service
 * Created by gyf .
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 获取单个开发者活动
     * @param appId
     * @param activityId
     * @param type
     * @return
     */
    DubboResult<OperatingActivityDto> getOperatingActivityDto(Long appId, Long activityId, Integer type);

    /**
     * 批量获取开发者活动
     * @param appId
     * @param activities
     * @return
     */
    DubboResult<List<OperatingActivityDto>> getOperatingActivityDtos(Long appId, List<Tuple.Tuple2<Integer, Long>> activities);

    /**
     * 获取链接 map key = operatingActivityId value = url
     * @param activities
     * @return
     */
    DubboResult<Map<Long, String>> getUrlMap(List<Tuple.Tuple2<Integer, Long>> activities);

    /**
     * 获取兑吧活动 标题
     * @param duibaActivityId
     * @param typeEnum
     * @return
     */
    DubboResult<String> getTitle(Long duibaActivityId, DuibaActivityTypeEnum typeEnum);
    DubboResult<Map<Long, String>> getUrlMapByAppId(List<Tuple.Tuple2<Integer, Long>> activities,Long appId);

    /**
     * 获取活动公共信息
     * @param activityIdAndTypeParamses
     * @return
     */
    DubboResult<List<ActivityCommonDto>> findActivitysByParams(List<ActivityIdAndTypeParam> activityIdAndTypeParamses);

    /**
     * 获取单个活动公共信息
     * @param activityId
     * @param type
     * @return
     */
    DubboResult<ActivityCommonDto> findActivitysByIdAndType(Long activityId,Integer type);

}
