package cn.com.duiba.activity.center.api.enums;

/**
 * Created by Liugq on 2018/12/21.
 * 红包广场奖励订单状态
 */
public enum LSExchangeStatusEnum {
    EXCHANGE_STATUS_INIT(-1, "初始化"),
    EXCHANGE_STATUS_NO(0, "无需领奖"),
    EXCHANGE_STATUS_WATTING(1, "待领奖"),
    EXCHANGE_STATUS_SUCCESS(2, "领奖成功"),
    EXCHANGE_STATUS_FAIL(3, "领奖失败"),
    EXCHANGE_STATUS_EXPIRE(4, "过期未领奖失效"),
    EXCHANGE_STATUS_DEALING(5, "领奖中")
    ;


    private Integer code;
    private String desc;

    LSExchangeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LSExchangeStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LSExchangeStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
