package cn.com.duiba.activity.center.api.enums;

/**
 * Created by Liugq on 2018/12/21.
 * 红包广场奖励类型
 */
public enum LSPrizeTypeEnum {
    PRIZE_TYPE_NEWUSER(0, "新用户奖励"),
    PRIZE_TYPE_SHARE(1, "首次分享奖励"),
    PRIZE_TYPE_ACCMULATE(2, "梯度拉新奖励"),
    ;


    private Integer code;
    private String desc;

    LSPrizeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LSPrizeTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LSPrizeTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
