package cn.com.duiba.activity.center.api.remoteservice.lotterysquare;

import cn.com.duiba.activity.center.api.dto.lotterysquare.LotterySquareBonusConfigDto;
import cn.com.duiba.activity.center.api.dto.lotterysquare.LotterySquareConfigDto;
import cn.com.duiba.activity.center.api.dto.lotterysquare.LotterySquareGradientRewardDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author chenxiangge
 * @Date 2018/12/6
 */
@AdvancedFeignClient
public interface RemoteLotterySquareBackendService {
    Long saveLotterySquareConfig(LotterySquareConfigDto lotterySquareConfig,List<LotterySquareBonusConfigDto> bonusConfigs, List<LotterySquareGradientRewardDto> gradientRewards);

    int updateLotterySquareConfig(LotterySquareConfigDto lotterySquareConfig);

    int saveLotteryBonusConfig(List<LotterySquareBonusConfigDto> bonusConfigs);

    int deleteLotteryBonusConfig(Long id);

    int updateLotteryBonusConfig(LotterySquareBonusConfigDto bonusConfig);

    int saveGradientReward(List<LotterySquareGradientRewardDto> lotterySquareGradientRewards);

    LotterySquareConfigDto findById(Long id);

    List<LotterySquareBonusConfigDto> findBonusConfigByActivityId(Long activityId);

    List<LotterySquareGradientRewardDto> findGradientRewardByActivityId(Long activityId);

    List<LotterySquareBonusConfigDto> findByActivityIdAndConsumerType(Long activityId, Integer consumerType);
}
