package cn.com.duiba.activity.center.api.dto.movebrick;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by sunchangji on 2018/12/28.
 */
public class DuibaBrickConfigDto implements Serializable{
	private static final long serialVersionUID = 465341083603593065L;
	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * 应用id
	 */
	private Long appId;

	/**
	 * 活动入库表id
	 */
	private Long opId;

	/**
	 * 活动名称
	 */
	private String title;

	/**
	 * 每日限制召唤次数
	 */
	private Integer dayLimit;

	/**
	 * 奖励类型。1:实物，2:红包，3:实物+红包
	 * @see cn.com.duiba.activity.center.api.enums.BrickRewardTypeEnum
	 */
	private Integer rewardType;

	/**
	 * 活动需要扣的积分数
	 */
	private Integer credits;

	/**
	 * 活动开始时间
	 */
	private Date startTime;

	/**
	 * 活动结束时间
	 */
	private Date endTime;

	/**
	 * 规则
	 */
	private String brickRule;

	/**
	 * 可中奖用户总人数
	 */
	private Integer winPrizeNum;

	/**
	 * 已中奖用户总人数
	 */
	private Integer winnedPrizeNum;

	/**
	 * 实物奖品库存预警邮箱
	 */
	private String objectPrizeWarnEmail;

	/**
	 * 领取奖品所需总砖块数
	 */
	private Integer exchangeTotalQuantity;

	/**
	 * 红包总预算。以分为单位
	 */
	private Integer redPacketBudget;

	/**
	 * 实物奖品未中奖用户可的总砖块数
	 */
	private Integer objectNotWinLimit;

	/**
	 * 单个非中奖用户发放额度
	 */
	private Integer redPacketNotWinLimit;

	/**
	 * 每次召唤可点击时间（秒）
	 */
	private Integer clickTime;

	/**
	 * 初级搬砖工召唤间隔时间（分）
	 */
	private Integer primaryCallInterval;

	/**
	 * 中级搬砖工召唤间隔时间（分）
	 */
	private Integer middleCallInterval;

	/**
	 * 高级搬砖工召唤间隔时间（分）
	 */
	private Integer seniorCallInterval;

	/**
	 * 初级搬砖工搬砖时间（分）
	 */
	private Integer primaryWork;

	/**
	 * 中级搬砖工搬砖时间（分）
	 */
	private Integer middleWork;

	/**
	 * 高级搬砖工搬砖时间（分）
	 */
	private Integer seniorWork;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getOpId() {
		return opId;
	}

	public void setOpId(Long opId) {
		this.opId = opId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getRewardType() {
		return rewardType;
	}

	public void setRewardType(Integer rewardType) {
		this.rewardType = rewardType;
	}

	public Integer getCredits() {
		return credits;
	}

	public void setCredits(Integer credits) {
		this.credits = credits;
	}

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getBrickRule() {
		return brickRule;
	}

	public void setBrickRule(String brickRule) {
		this.brickRule = brickRule;
	}

	public Integer getWinPrizeNum() {
		return winPrizeNum;
	}

	public void setWinPrizeNum(Integer winPrizeNum) {
		this.winPrizeNum = winPrizeNum;
	}

	public Integer getWinnedPrizeNum() {
		return winnedPrizeNum;
	}

	public void setWinnedPrizeNum(Integer winnedPrizeNum) {
		this.winnedPrizeNum = winnedPrizeNum;
	}

	public String getObjectPrizeWarnEmail() {
		return objectPrizeWarnEmail;
	}

	public void setObjectPrizeWarnEmail(String objectPrizeWarnEmail) {
		this.objectPrizeWarnEmail = objectPrizeWarnEmail;
	}

	public Integer getExchangeTotalQuantity() {
		return exchangeTotalQuantity;
	}

	public void setExchangeTotalQuantity(Integer exchangeTotalQuantity) {
		this.exchangeTotalQuantity = exchangeTotalQuantity;
	}

	public Integer getRedPacketBudget() {
		return redPacketBudget;
	}

	public void setRedPacketBudget(Integer redPacketBudget) {
		this.redPacketBudget = redPacketBudget;
	}

	public Integer getObjectNotWinLimit() {
		return objectNotWinLimit;
	}

	public void setObjectNotWinLimit(Integer objectNotWinLimit) {
		this.objectNotWinLimit = objectNotWinLimit;
	}

	public Integer getRedPacketNotWinLimit() {
		return redPacketNotWinLimit;
	}

	public void setRedPacketNotWinLimit(Integer redPacketNotWinLimit) {
		this.redPacketNotWinLimit = redPacketNotWinLimit;
	}

	public Integer getClickTime() {
		return clickTime;
	}

	public void setClickTime(Integer clickTime) {
		this.clickTime = clickTime;
	}

	public Integer getPrimaryCallInterval() {
		return primaryCallInterval;
	}

	public void setPrimaryCallInterval(Integer primaryCallInterval) {
		this.primaryCallInterval = primaryCallInterval;
	}

	public Integer getMiddleCallInterval() {
		return middleCallInterval;
	}

	public void setMiddleCallInterval(Integer middleCallInterval) {
		this.middleCallInterval = middleCallInterval;
	}

	public Integer getSeniorCallInterval() {
		return seniorCallInterval;
	}

	public void setSeniorCallInterval(Integer seniorCallInterval) {
		this.seniorCallInterval = seniorCallInterval;
	}

	public Integer getPrimaryWork() {
		return primaryWork;
	}

	public void setPrimaryWork(Integer primaryWork) {
		this.primaryWork = primaryWork;
	}

	public Integer getMiddleWork() {
		return middleWork;
	}

	public void setMiddleWork(Integer middleWork) {
		this.middleWork = middleWork;
	}

	public Integer getSeniorWork() {
		return seniorWork;
	}

	public void setSeniorWork(Integer seniorWork) {
		this.seniorWork = seniorWork;
	}

	public Integer getDayLimit() {
		return dayLimit;
	}

	public void setDayLimit(Integer dayLimit) {
		this.dayLimit = dayLimit;
	}
}
