package cn.com.duiba.activity.center.api.remoteservice.shuqi;

import cn.com.duiba.activity.center.api.dto.BizResultDto;
import cn.com.duiba.activity.center.api.dto.shuqipk.PkTeamInfoDto;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2018/12/27 19:47
 * @description:
 */
@AdvancedFeignClient
public interface RemotePkTeamInfoService {
    /**
     * 新建战队
     * @param dto 战队信息
     * @return
     */
    Long insert(PkTeamInfoDto dto);

    /**
     * 查询战队名称是否存在
     * @param teamName
     * @return
     */
    Boolean teamNameExist(String teamName);

    BizResultDto batchUpdateReadValue(List<PkTeamInfoDto> infos);

	/**
	 * 根据战队id获取战队信息
	 */
	PkTeamInfoDto getById(Long teamId);

    /**
     * 分页获取战队列表
     * @param page
     * @return
     */
    List<Long> getTeamPage(PageQuery page);

	/**
	 * 根据战队id list批量查询战队信息
	 */
	List<PkTeamInfoDto> getListByIds(List<Long> teamIdList);
}
