package cn.com.duiba.activity.center.api.remoteservice.shuqi;

import cn.com.duiba.activity.center.api.dto.shuqipk.PkTeamRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * @author: zhengjianhao
 * @date: 2018/12/27 19:47
 * @description:
 */
@AdvancedFeignClient
public interface RemotePkTeamRecordService {

	Integer insertBatch(List<PkTeamRecordDto> records);

	/**
	 * 根据记录id查询
	 */
	PkTeamRecordDto getById(Long teamRecordId);

	/**
	 * 根据战队id和日期获取pk记录，只查pk的
	 */
	PkTeamRecordDto getByTeamIdAndDate(Long teamId, Long recordDate);

	/**
	 * 新增pk记录
	 */
	PkTeamRecordDto addPkRecords(Long teamId, Long enemyTeamId, Long recordDate) throws BizException;

	/**
	 * 同步pk阅读值
	 */
	PkTeamRecordDto updateReadValue(PkTeamRecordDto pkTeamRecordDto, Map<Long, Long> consumerReadTimeMap, Boolean lastSync) throws BizException;

	/**
	 * 根据战队id，获取战队今天之前的记录，包括pk、成员加入、组队成功
	 */
	List<PkTeamRecordDto> getPastByTeamId(Long teamId);

}
