package cn.com.duiba.activity.center.api.remoteservice.fakeuser;

import cn.com.duiba.activity.center.api.dto.fakeuser.FakeUserDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 拼团活动配置
 */
@AdvancedFeignClient
public interface RemoteFakeUserService {

	/**
	 * 根据业务id获取假用户id
	 * @param bizId
	 * @return
	 */
	FakeUserDto getByBizId(Long bizId);

	/**
	 * 根据id list批量获取假用户信息
	 */
	List<FakeUserDto> getByIds(List<Long> idList);

	/**
	 * 批量插入
	 */
	void batchInsert(List<FakeUserDto> fakeUserDtoList);

	/**
	 * 根据数量，随机取出指定数量的假用户
	 */
	List<FakeUserDto> getRandomUsersWithCount(Integer count);
}
