package cn.com.duiba.activity.center.api.remoteservice.betv2;

import cn.com.duiba.activity.center.api.dto.betv2.BetV2ListRecordDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * RemoteBetV2RecordService
 *
 * @author ChenXiangge
 * @date 28/06/2018
 */
@AdvancedFeignClient
public interface RemoteBetV2RecordService {

    /**
     * 往日胜利战绩
     * @param consumerId
     * @param appId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<BetV2ListRecordDto> list(Long consumerId, Long appId, Integer pageNo, Integer pageSize);

    /**
     * 活动用户参与pk活动的次数
     * @param consumerId  用户id
     * @return 押注的总次数
     */
    Long findBetTimesByConsumerId(Long consumerId);

    /**
     * 是否可以插件抽奖
     * @param betId pk赛活动
     * @param consumerId 用户id
     * @return 是否可以插件抽奖
     */
    Boolean ifICanDraw(Long betId, Long consumerId);

    /**
     * 汇总活动下有多少个用户，已押注题目的总金额大于活动上限金额（包括未开奖的）
     * @param betIds 押注题目的id集合
     * @param appId
     * @return
     */
    Integer getTotalBeyondLimitMoneyCount(Long appId, List<Long> betIds, Integer limitMoney) throws BizException;

    /**
     * 汇总活动下用户，已押注题目的总金额（包括未开奖的）
     * @param betIds 押注题目的id集合
     * @param appId
     * @return
     */
    Integer getTotalMoneyByConusmer(Long appId,List<Long> betIds,Long consumerId) throws BizException;

    /**
     *获取结算金额大于可提现金额的用户ids
     * @param appId
     * @param betIds 押注题目的id集合
     * @param bonusAmount 提现金额上限
     * @param consumerIds 用户id集合
     * @param bonusAmount
     * @return
     */
    List<Long> getBeyongBonusAmountByConusmers(Long appId, List<Long> betIds, List<Long> consumerIds,Integer bonusAmount) throws BizException ;

    /**
     * 获取已获得结算金额小于的提现金额上限的用户，倒叙排列
     * @param betIds 押注题目的id集合
     * @param appId
     * @param bonusAmount 提现金额上限
     * @param personSize 需要查询的用户个数
     * @return
     */
    List<Long> getConsumersLowAmount(Long appId,List<Long> betIds,Integer bonusAmount,Integer personSize,List<Long> cids)throws BizException ;



}
