package cn.com.duiba.activity.center.api.dto.bargain;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;

/**
 * @author author
 */
public class BargainRecordDto implements Serializable {

    private static final long serialVersionUID = 6256983123644652541L;
    /**
     * 主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 砍价订单id,来源tb_bargain_order.id
     * isNullAble:0
     */
    private Long bargainOrderId;

    /**
     * 用户id
     * isNullAble:0
     */
    private Long consumerId;

    /**
     * 帮砍好友的用户id
     * isNullAble:0
     */
    private Long helpConsumerId;

    /**
     * 帮砍金额(分)
     * isNullAble:0
     */
    private Integer helpBargainPrice;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBargainOrderId() {
        return bargainOrderId;
    }

    public void setBargainOrderId(Long bargainOrderId) {
        this.bargainOrderId = bargainOrderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getHelpConsumerId() {
        return helpConsumerId;
    }

    public void setHelpConsumerId(Long helpConsumerId) {
        this.helpConsumerId = helpConsumerId;
    }

    public Integer getHelpBargainPrice() {
        return helpBargainPrice;
    }

    public void setHelpBargainPrice(Integer helpBargainPrice) {
        this.helpBargainPrice = helpBargainPrice;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public static BargainRecordDto decode(byte[] msg) {
        String string = new String(msg, Charset.forName("utf-8"));
        return StringUtils.isEmpty(string) ? null : (BargainRecordDto) JSONObject.parseObject(string, BargainRecordDto.class);
    }
}
