package cn.com.duiba.activity.center.api.enums;

/**
 * @author: zhengjianhao
 * @date: 18/4/4 16:57
 * @description: 限制周期
 */
public enum JoinGroupStatusEnum {
    UNDER_WAY(0, "进行中"),
    SUCCESS(1, "成功"),
    FAILURE(2, "失败"),
	;

    Integer code;
    String desc;

    JoinGroupStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

	public static JoinGroupStatusEnum getByCode(Integer code) {
		if (code == null) {
			return null;
		}
		for (JoinGroupStatusEnum statusEnum : values()) {
			if (code.equals(statusEnum.code)) {
				return statusEnum;
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
}
