package cn.com.duiba.activity.center.api.remoteservice.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticTakeOrderDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.javatuples.Pair;

import java.util.List;

/**
 * 弹层礼包接口,手机端用
 */
@AdvancedFeignClient
public interface RemoteElasticGiftsService {

    /**
     * 获取app 对应的礼包活动以及活动项
     * @param appId
     * @param bizCode
     * @return
     */
    @Deprecated
    DubboResult<Tuple.Tuple2<ElasticGiftsDto, List<ElasticGiftsTermDto>>> getElasticGiftsForMobile(ElasticGiftsBizCodeEnum bizCode, Long appId);

    /**
     * 获取app 对应的礼包活动以及活动项
     * @param appId
     * @param bizCode
     * @return
     */
    DubboResult<Pair<ElasticGiftsDto, List<ElasticGiftsTermDto>>> getElasticGiftsForMobileApi(ElasticGiftsBizCodeEnum bizCode, Long appId);

    /**
     * 下单校验
     * @param egTermId
     * @param appId
     * @return
     */
    DubboResult<ElasticTakeOrderDto> checkElasticTakeOrder(Long egTermId, Long appId);
}
