package cn.com.duiba.activity.center.api.remoteservice.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@AdvancedFeignClient
public interface RemoteGuessOrdersService {
    public List<GuessOrdersDto> findWinByGuessIdAndPrizeId(Long duibaGuessId, Long prizeId);

    /**
     * 
     * findWinOrderByExactMatch:(这里用一句话描述这个方法的作用). <br/>
     * 精确匹配获取中奖名单
     * @param duibaGuessId
     * @param winIds
     * @param guessData
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData);
    
    /**
     * 
     * findWinOrderByVagueMatch:(这里用一句话描述这个方法的作用). <br/>
     * 模糊匹配获取中奖名单
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData);


    //from manager

    /**
     * 
     * findExpireOrder:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findExpireOrder();
    
    /**
     * 
     * findWinOrderByExactMatch:(这里用一句话描述这个方法的作用). <br/>
     * 精确匹配获取中奖名单
     * @param duibaGuessId
     * @param winIds
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    @RequestMapping("/findWinOrderByExactMatch1")
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData, Integer offset, Integer max, Long consumerId);
    
    /**
     * 
     * findWinOrderByVagueMatch:(这里用一句话描述这个方法的作用). <br/>
     * 模糊匹配获取中奖名单
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    @RequestMapping("/findWinOrderByVagueMatch1")
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData, Integer offset, Integer max, Long consumerId);


    /**
     * 随机获取当前竞猜活动订单，除中一等奖的用户之外每一个用户获取一条订单记录
     * @param guessId  当前竞猜id
     * @param guessData  竞猜选项
     * @param consumerId  一等奖用户id
     * @param createTime  竞猜创建时间
     * @param size  查询记录数
     * @return
     */
    List<Long> findAllWinOrderId(Long guessId, String guessData, Long consumerId, Date createTime, Integer size);

    /**
     * 根据id批量查询
     * @return
     */
    List<GuessOrdersDto> findByIds(List<Long> ids);




}
