/**
 * Project Name:activity-center-api
 * File Name:RemoteSignFlowInnerService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.sign
 * Date:2017年3月6日上午9:51:27
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.sign;

import cn.com.duiba.activity.center.api.dto.activity_order.ActivityOrderDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteSignFlowInnerService <br/>
 * Date:     2017年3月6日 上午9:51:27 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteSignFlowInnerService {

    /**
     * 1.中奖概率计算 计算过程说明： <br/>
     * 将每一个奖项的概率相加，如果小于100，则认为缺失部分概率为谢谢参与。<br/>
     * 如果大于100，则超出100部分永远无法中奖(即使前面的商品已经抽完，后面的奖项也无法被抽中) 此处设计可能有缺陷！！！<br/>
     * 
     * @param operatingActivityDO
     *            运营活动信息
     * @return 根据概率抽中的奖项
     * @throws Exception
     */
    public DubboResult<ActivityPrizeOptionDto> randomPrize(Long activityId, String activityType, List<ActivityPrizeOptionDto> options);
    
    /**
     * 2.处理中奖奖项<br/>
     * 
     * 开启事务 锁 option奖项记录 <br/>
     * 1:减奖项剩余个数<br/>
     * 2:减活动定向个数 <br/>
     * 3:减兑换项库存<br/>
     * 4:更新中奖信息到用户抽奖订单（状态：成功，领奖状态：待领奖）<br/>
     * 5:记录用户兑换记录（待领奖）<br/>
     * 6:提交事务
     */
    @Deprecated
    public void doWinPrize(ActivityOrderDto order, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options, String ip, String ua, String os, SignConfigDto signDto)throws BusinessException, StatusException;

    public void doWinPrizeApi(ActivityOrderDto order, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options, String ip, String ua, String os, SignConfigDto signDto);
    
    /**
     * 4.默认设置中谢谢参与： <br/>
     * 
     * @param activityId
     * @param activityType
     * @return 根据概率抽中的奖项
     * @throws Exception
     */
    public DubboResult<ActivityPrizeOptionDto> awardThanks(Long activityId,String activityType);
    
    /**
     * 5.奖项配置与属性的验证<br/>
     * 
     * 1.奖项是否已经被删除<br/>
     * 2.奖项是否还有库存 <br/>
     * 3.奖项保底人数是否满足<br/>
     * 4.奖项用户中奖限制<br/>
     * 
     * @param operatingActivityDO
     * @param option
     * @param order
     * @return
     * @throws Exception
     */
    public DubboResult<ActivityPrizeOptionDto> winOptionCheck(ActivityOrderDto order, ActivityPrizeOptionDto winOption,List<ActivityPrizeOptionDto> options);
    
    /**
     * 6.奖项商品(ItemKey)是否可用计算 包含以下的限制条件<br/>
     * 
     * 1.兑换项被禁用或者删除<br/>
     *      AppItem和Item同时判断，有一处不符合，即拒绝<br/>
     * 2.有兑换限制的兑换项<br/>
     *      限时(钟点时间段) <br/>
     *      限量<br/>
     *      日期限制<br/>
     *      用户兑换限制(每天/永久/每月/批次，AppItem/Item只有有一个符合，就拒绝) <br/>
     *      地域限制(白名单，名单内可中奖。黑名单，名单内不可中奖) <br/>
     * 3.兑换项没库存<br/>
     * 4.兑换项过期失效<br/>
     * 5.有APP兑换限制的只能中测试专用<br/>
     * 
     * @param operatingActivityDO
     *            运营活动信息
     * @param option
     *            根据概率抽中的奖项
     * @param order
     *            活动订单
     * @return true 可以中奖，false 不可以中奖
     */
    public DubboResult<Boolean> validItemKeyCheck(ActivityOrderDto order,ActivityPrizeOptionDto prize, boolean check);
}

