package cn.com.duiba.activity.center.api.dto.flow;

import cn.com.duiba.activity.center.api.tool.ActivityFlowRuleParseUtil;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * Created by sty on 9/22/17.
 */
public  class ActivityFlowRuleModleDto implements Serializable {
    private static final long serialVersionUID = -1330954902134464439L;
    private Long appId;
    // 规则类型：特殊流量1；其他流量2
    private Integer ruleType;
    private Integer activityType;
    private List<Long> activityIds;
    private Set<String> validRegions;
    private Integer proxyFlag;
    public ActivityFlowRuleModleDto(){
        //默认构造器
    }

    public ActivityFlowRuleModleDto(ActivityFlowRuleDto activityFlowRuleDto) {
        this.appId = activityFlowRuleDto.getAppId();
        this.ruleType = activityFlowRuleDto.getRuleType();
        this.activityType = activityFlowRuleDto.getActivityType();
        this.activityIds = ActivityFlowRuleParseUtil.parseActivityIdsAllowNull(activityFlowRuleDto.getActivityIds());
        this.validRegions = ActivityFlowRuleParseUtil.parseRegions(activityFlowRuleDto.getValidRegions());
        this.proxyFlag = activityFlowRuleDto.getProxyFlag();

    }


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public Set<String> getValidRegions() {
        return validRegions;
    }

    public void setValidRegions(Set<String> validRegions) {
        this.validRegions = validRegions;
    }

    public Integer getProxyFlag() {
        return proxyFlag;
    }

    public void setProxyFlag(Integer proxyFlag) {
        this.proxyFlag = proxyFlag;
    }
}