package cn.com.duiba.activity.center.api.remoteservice.freegroup;

import cn.com.duiba.activity.center.api.dto.freegroup.FreeGroupRecordDto;
import cn.com.duiba.activity.center.api.dto.freegroup.FreeGroupUserRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @Author: lufeng
 * @Description: 0元拼团工具记录接口
 * @Date: Created in 2019/3/14
 */
@AdvancedFeignClient
public interface RemoteFreeGroupRecordService {

    /**
     * 获取成团信息
     * @param groupRecordId
     * @return
     */
    FreeGroupRecordDto getGroupRecord(Long groupRecordId);

    /**
     * 批量获取团信息表记录
     * @param groupRecordIds
     * @return
     */
    List<FreeGroupRecordDto> listGroupRecord(List<Long> groupRecordIds);

    /**
     * 按拼团完成时间倒序排序获取前num的团信息
     * @param configId
     * @param groupItemId
     * @param num
     * @return
     */
    List<FreeGroupRecordDto> listGroupRecordWithPrize(Long configId, Long groupItemId, Integer num);

    /**
     * 修改团状态
     * @param groupRecordId
     * @param groupStatus
     * @return
     */
    boolean updateFreeGroupRecordStatus(Long groupRecordId, Integer groupStatus);


    /**
     * 获取用户在某个团的信息
     * @param configId
     * @param consumerId
     * @param groupItemId
     * @return
     */
    FreeGroupUserRecordDto getGroupUserRecord(Long configId, Long consumerId, Long groupItemId);

    /**
     * 获取一个团下面的用户信息
     * @param configId
     * @param groupRecordId
     * @return
     */
    List<FreeGroupUserRecordDto> listGroupUserRecordByGroupRecordId(Long configId, Long groupRecordId);

    /**
     * 获取用户参团记录
     * @param configId 活动配置表id
     * @param consumerId 用户id
     * @return
     */
    List<FreeGroupUserRecordDto> listGroupUserRecordByConsumerId(Long configId, Long consumerId);

    /**
     * 批量更新用户参团表 用户拼团状态
     * @param groupRecordId
     * @param recordStatus
     * @return
     */
    boolean updateFreeGroupUserRecordStatusByGroupRecordId(Long groupRecordId, Integer recordStatus);

    /**
     *
     * @param id
     * @param recordStatus
     * @return
     */
    boolean updateFreeGroupUserRecordStatusById(Long id, Integer recordStatus);

    /**
     * 获取app维度下用户参与拼团商品数
     * @param appId
     * @param consumerId 用户id
     * @return
     */
    int countGroupUserRecordByAppAndConsumerId(Long appId, Long consumerId);

    /**
     * 获取一个团下面已参的用户数
     * @param configId
     * @param groupRecordId
     * @return
     */
    int countGroupUserRecordByGroupRecordId(Long configId, Long groupRecordId);

    /**
     * 开团
     * @param appId
     * @param configId
     * @param groupItemId
     * @param endTime
     * @param consumerId
     * @param fromType
     * @return
     */
    Long doOpenGroup(Long appId, Long configId, Long groupItemId, Date endTime, Long consumerId, Integer fromType);

    /**
     * 参团
     * @param appId
     * @param configId
     * @param groupItemId
     * @param consumerId
     * @param groupRecordId
     * @param fromType
     * @param willFull 参团后是否满员
     * @return
     */
    Boolean doJoinGroup(Long appId, Long configId, Long groupItemId, Long consumerId, Long groupRecordId, Integer fromType, boolean willFull);

}
