package cn.com.duiba.activity.center.api.enums;

/**
 * 幸运码用户奖品状态枚举
 * author zhanghuifeng
 * date 2019-03-20-16:18
 */
public enum LuckyCodeUserAwardStateEnum {

    FINISH_DRAW(1, "已领奖"),
    UN_FINISH_DRAW(0, "未领奖"),
    FAIL_DRAW(2, "领奖失败")
    ;


    private Integer code;
    private String desc;

    LuckyCodeUserAwardStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LuckyCodeUserAwardStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (LuckyCodeUserAwardStateEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
