package cn.com.duiba.activity.center.api.remoteservice.luckycode;

import cn.com.duiba.activity.center.api.dto.luckycode.LuckyCodeUserAwardRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 用户中奖记录Service
 * author zhanghuifeng
 * date 2019-03-20-15:57
 */
@AdvancedFeignClient
public interface RemoteLuckyCodeUserAwardRecordService {

    /**
     * 获取用户活动奖品配置id
     * @param consumerId
     * @param activityId
     * @param state @see LuckyCodeUserAwardStateEnum
     * @return
     */
    List<Long> findUserActAward(Long consumerId, Long activityId, Integer state);

    /**
     * 获取用户活动奖品配置
     * @param consumerId
     * @param activityId
     * @param state
     * @return
     */
    List<LuckyCodeUserAwardRecordDto> findUserAwardRecords(Long consumerId, Long activityId, Integer state);

    /**
     * 获取前面指定个数的中奖记录
     * @param awardConfigId
     * @param state
     * @param limit
     * @return
     */
    List<LuckyCodeUserAwardRecordDto> findAwardTopLimitWiningRecords(Long awardConfigId, Integer state, Integer limit);

    /**
     * 获取用户活动奖品id和状态
     * @param consumerId
     * @param activityId
     * @param state
     * @return
     */
    Map<Long, Integer> findUserAwardWithState(Long consumerId, Long activityId, Integer state);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    LuckyCodeUserAwardRecordDto findById(Long id);

    /**
     * 更新状态
     *
     * @param id
     * @param state
     * @return
     */
    int updateStateById(Long id, Integer state);

    /**
     * 更新商品扩展信息
     *
     * @param id
     * @param itemValue
     * @return
     */
    int updateItemValueById(Long id, String itemValue);

    /**
     * 保存
     *
     * @param record
     * @return
     */
    Long save(LuckyCodeUserAwardRecordDto record);
}
