package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.dto.BaseDto;

import java.io.Serializable;

/**
 * 奖励配置
 * Created by xiaoxuda on 2017/6/1.
 */
public class SignRewardRuleItemDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = -1695582366948553867L;

    /**
     * 签到规则在json配置中的key
     */
    public static final String KEY_DAYS = "days";
    public static final String KEY_CREDITS = "credits";
    public static final String KEY_ACTIVITY_COUNT = "activityCount";

    /**
     * 天数，不同签到规则具有不同意思
     */
    private Integer days;
    /**
     * 加积分数量
     */
    private Integer credits = 0;
    /**
     * 加活动次数数量
     */
    private Integer activityCount = 0;

    public boolean isValid(){
        return (credits != null && credits > 0) || (activityCount != null && activityCount > 0);
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

}
