package cn.com.duiba.activity.center.api.remoteservice.luckycode;

import cn.com.duiba.activity.center.api.dto.luckycode.LuckyCodeUserScratchInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 用户刮奖信息Service
 * author zhanghuifeng
 * date 2019-03-20-15:59
 */
@AdvancedFeignClient
public interface RemoteLuckyCodeUserScratchInfoService {
    /**
     * 根据用户id和奖品id查询
     * @param consumerId
     * @param awardId
     * @return
     */
    LuckyCodeUserScratchInfoDto findByConsumerIdAndAwardId(Long consumerId, Long awardId);

    /**
     * 保存用户刮奖信息
     * @param userScratchInfo
     * @return
     */
    Long save(LuckyCodeUserScratchInfoDto userScratchInfo);

    /**
     * 更新用户抽奖码
     *  @param id
     * @param lotteryCode
     */
    boolean updateLotteryCode(Long id, String lotteryCode);

    /**
     * 增加用户当天修改次数
     * @param consumerId
     * @param awardConfigId
     * @return
     */
    Boolean addScratchTotal(Long consumerId, Long awardConfigId);
}
