package cn.com.duiba.activity.center.api.remoteservice.luckycode;

import cn.com.duiba.activity.center.api.dto.luckycode.LuckyCodeUserScratchRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.springframework.transaction.annotation.Transactional;

/**
 * 用户刮奖记录Service
 * author zhanghuifeng
 * date 2019-03-20-16:00
 */
@AdvancedFeignClient
public interface RemoteLuckyCodeUserScratchRecordService {
    /**
     * 根据id查询
     * @param id
     * @return
     */
    LuckyCodeUserScratchRecordDto findById(Long id);

    /**
     * 更新状态
     * @param id
     * @param state
     * @return
     */
    boolean updateStateById(Long id, Integer state);

    /**
     * 更新积分消耗订单编号
     * @param id
     * @param orderNum
     * @return
     */
    boolean updateOrderNum(Long id, String orderNum);

    /**
     * 结束刮奖流程，更新抽奖码和状态
     * @param scratchRecordId
     * @param scratchInfoId
     * @param lotteryCode
     * @param state
     * @return
     */
    boolean finishScratch(Long scratchRecordId, Long scratchInfoId, String lotteryCode, Integer state);

    /**
     * 保存刮奖记录
     * @param userScratchRecord
     * @return
     */
    Long save(LuckyCodeUserScratchRecordDto userScratchRecord);
}
