package cn.com.duiba.activity.center.api.remoteservice.happygroup;

import cn.com.duiba.activity.center.api.dto.happygroup.HappyGroupInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/2/26 15:18
 * @description: 拼拼乐活动团信息
 */
@AdvancedFeignClient
public interface RemoteHappyGroupInfoAppService {

	/**
	 * 新增团
	 */
	Long add(HappyGroupInfoDto entity);

	/**
	 * 拼团成功处理
	 */
	void modifyToSuccess(Long groupId);

	/**
	 * 拼团失败处理
	 */
	void modifyToFailure(Long groupId, Long groupItemId);

	/**
	 * 按拼团id获取团信息
	 */
	HappyGroupInfoDto getById(Long id);

	/**
	 * 按拼团id列表批量获取拼团信息
	 */
	List<HappyGroupInfoDto> getByIdList(List<Long> idList);
}
